#!/bin/sh
###############################################################################
# Copyright 2004-2021, Way to the Web Limited
# URL: http://www.configserver.com
# Email: sales@waytotheweb.com
###############################################################################
PATH=$PATH:/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin

if [ ! -e "msinstall.pl" ]; then
	echo "You must be inside the msintall directory to run this installer"
    exit
fi

if [ -e "/usr/local/cpanel/version" ]; then
    find ./ \( -name "*.pm" -o -name "*.pl" -o -name "*.cgi" -o -name "*.cron" \) -type f -exec sed -i 's%/usr/bin/perl%/usr/local/cpanel/3rdparty/bin/perl%' {} \;
    sed -i 's%/usr/bin/perl%/usr/local/cpanel/3rdparty/bin/perl%' MailScanner/usr/sbin/*
else
    find ./ \( -name "*.pm" -o -name "*.pl" -o -name "*.cgi" -o -name "*.cron" \) -type f -exec sed -i 's%/usr/local/cpanel/3rdparty/bin/perl%/usr/bin/perl%' {} \;
    sed -i 's%/usr/local/cpanel/3rdparty/bin/perl%/usr/bin/perl%' MailScanner/usr/sbin/*
fi

chmod +x MailScanner/usr/sbin/*

#find ./ -type f -exec dos2unix {} \; > /dev/null 2>&1

echo
echo "Installing MailScanner service ..."
echo
if [ -e "/proc/1/comm" ]; then
    if test `cat /proc/1/comm` = "systemd"
    then
        if [ -e /etc/init.d/MailScanner ]; then
            rm -fv /etc/init.d/MailScanner
        fi
        mkdir -p /etc/systemd/system/
        mkdir -p /usr/lib/systemd/system/
        cp -af MailScanner.service  /usr/lib/systemd/system/
        systemctl daemon-reload
        systemctl enable MailScanner.service
    else
        cp -af MailScanner.init /etc/init.d/MailScanner
        chmod 700 /etc/init.d/MailScanner
        chkconfig MailScanner on
    fi
else
    cp -af MailScanner.init /etc/init.d/MailScanner
    chmod 700 /etc/init.d/MailScanner
    chkconfig MailScanner on
fi

echo
echo "Copying MailScanner scripts..."
echo
if [ -d "/usr/mscpanel" ]; then
    mv /usr/mscpanel /usr/msfe
fi
if [ ! -e "/usr/msfe" ]; then
	mkdir /usr/msfe
fi
ln -s /usr/msfe /usr/mscpanel
/bin/cp -af mscheck.pl /usr/msfe/
/bin/cp -af msrules.pl /usr/msfe/
/bin/cp -af msreq.pl /usr/msfe/
if [ -e "/usr/msfe/mscpanel.pl" ]; then
    /bin/rm -f /usr/msfe/mscpanel.pl
fi
ln -s /usr/msfe/msrules.pl /usr/msfe/mscpanel.pl
/bin/cp -af version.txt /usr/msfe/
/bin/cp -af mailscanner_daily.cron /etc/cron.daily/
/bin/cp -af Missing /usr/msfe/
chmod 700 /usr/msfe/mscheck.pl
chmod 700 /usr/msfe/msrules.pl
chmod 700 /usr/msfe/msreq.pl
chmod 700 /etc/cron.daily/mailscanner_daily.cron


if [ -e "/usr/local/cpanel/version" ]; then
    echo
    echo "Make sure cPanel perl modules are installed..."
    echo

    /usr/local/cpanel/3rdparty/bin/perl version.pl
else
    touch /usr/msfe/mailscannerq
fi

echo
echo "Performing MailScanner installation/upgrade..."
echo
chmod +x msinstall.pl
./msinstall.pl 1
echo

if [ -e "/usr/msfe/mailcontrol/dbadd.pl" ]; then
    /usr/msfe/mailcontrol/dbadd.pl
fi

echo "(Re)starting MailScanner..."
/sbin/service MailScanner restart

echo
echo "All done."
